package myBean;

import java.sql.*;
import myBean.DBConnection;


public class QueryPage {
	private DBConnection dbconn = new DBConnection();
	
	public QueryPage() {
	}

	public ResultSet getPageof(String sql, String pg, int pagesize) {
		int page = Integer.parseInt(pg);
		int count = dbconn.getCount();
		if(count==0)
			return null;
		
		int totalpage = (count+pagesize-1)/pagesize;
		
		if(page > totalpage)
			page = totalpage;
			
		ResultSet rs = dbconn.execQuery(sql);
		
		int start = (page-1)*pagesize;
		try {
			for(int i=0; i<start; i++)
				rs.next();
		}catch(SQLException e) {
			System.err.println("QueryPage.getPageof()" +e.getMessage());
		}
		
		return rs;
	}
	
	public int totalPage(int pagesize) {
		return (dbconn.getCount()+pagesize-1)/pagesize;
	}
/*	
	public static void main(String []args) {
		ResultSet rs = (new QueryPage()).getPageof("select name from users", "2", 5);
		
		try {
			while(rs.next()) {
				System.out.println(rs.getString("name"));
			}
		}catch(SQLException e) {
		}
	}	
*/
}